<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://webtospec.com
 * @since             1.0.0
 * @package           Woo_Bg_Dual_Currency
 *
 * @wordpress-plugin
 * Plugin Name:       Bulgaria Dual Currency
 * Plugin URI:        https://webtospec.com
 * Description:       Plugin that displays all WooCommerce in EUR as well as BGN to make the EUR  acceptance in Bulgaria easier
 * Version:           1.0.0
 * Author:            Web To Spec
 * Author URI:        https://webtospec.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       woo-bg-dual-currency
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (! defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('WOO_BG_DUAL_CURRENCY_VERSION', '1.0.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-woo-bg-dual-currency-activator.php
 */
function activate_woo_bg_dual_currency()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-woo-bg-dual-currency-activator.php';
	Woo_Bg_Dual_Currency_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-woo-bg-dual-currency-deactivator.php
 */
function deactivate_woo_bg_dual_currency()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-woo-bg-dual-currency-deactivator.php';
	Woo_Bg_Dual_Currency_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_woo_bg_dual_currency');
register_deactivation_hook(__FILE__, 'deactivate_woo_bg_dual_currency');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-woo-bg-dual-currency.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_woo_bg_dual_currency()
{

	$plugin = new Woo_Bg_Dual_Currency();
	$plugin->run();
}
run_woo_bg_dual_currency();
