<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://webtospec.com
 * @since      1.0.0
 *
 * @package    Woo_Bg_Dual_Currency
 * @subpackage Woo_Bg_Dual_Currency/admin/partials
 */
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <?php if (! Woo_Bg_Dual_Currency_Core::is_bgn_currency()): ?>
        <div class="notice notice-warning">
            <p><strong><?php _e('Notice:', 'woo-bg-dual-currency'); ?></strong>
                <?php _e('Dual currency display is only active when your store currency is set to Bulgarian Lev (BGN). Current currency:', 'woo-bg-dual-currency'); ?>
                <strong><?php echo get_woocommerce_currency(); ?></strong>
            </p>
            <p>
                <a href="<?php echo admin_url('admin.php?page=wc-settings&tab=general'); ?>" class="button">
                    <?php _e('Go to Currency Settings', 'woo-bg-dual-currency'); ?>
                </a>
            </p>
        </div>
    <?php else: ?>
        <div class="notice notice-success">
            <p><strong><?php _e('Active:', 'woo-bg-dual-currency'); ?></strong>
                <?php _e('Dual currency display is currently active for BGN/EUR.', 'woo-bg-dual-currency'); ?>
            </p>
        </div>
    <?php endif; ?>

    <form method="post" action="options.php">
        <?php
        settings_fields('woo_bg_dual_currency_settings');
        do_settings_sections('woo_bg_dual_currency_settings');
        ?>

        <table class="form-table">
            <tr>
                <th scope="row"><?php _e('Current Store Currency', 'woo-bg-dual-currency'); ?></th>
                <td>
                    <strong><?php echo get_woocommerce_currency(); ?></strong>
                    (<?php echo get_woocommerce_currency_symbol(); ?>)
                </td>
            </tr>

            <?php if (Woo_Bg_Dual_Currency_Core::is_bgn_currency()): ?>
                <tr>
                    <th scope="row"><?php _e('Current Conversion Rate', 'woo-bg-dual-currency'); ?></th>
                    <td>
                        <strong>1 BGN = <?php echo Woo_Bg_Dual_Currency_Core::get_conversion_rate(); ?> EUR</strong><br>
                        <em><?php _e('Based on official Bulgarian National Bank rate', 'woo-bg-dual-currency'); ?></em>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php _e('Example Price Display', 'woo-bg-dual-currency'); ?></th>
                    <td>
                        <div style="padding: 10px; border: 1px solid #ddd; background: #f9f9f9; display: inline-block;">
                            <?php
                            $example_price = 100;
                            echo Woo_Bg_Dual_Currency_Core::format_dual_currency(wc_price($example_price), $example_price);
                            ?>
                        </div>
                        <p class="description"><?php _e('This is how prices will appear on your store.', 'woo-bg-dual-currency'); ?></p>
                    </td>
                </tr>
            <?php endif; ?>
        </table>

        <?php submit_button(); ?>
    </form>

    <hr>

    <h2><?php _e('Supported Areas', 'woo-bg-dual-currency'); ?></h2>
    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
        <div>
            <h3><?php _e('Frontend Display', 'woo-bg-dual-currency'); ?></h3>
            <ul style="list-style: disc; margin-left: 20px;">
                <li><?php _e('Shop page (WooCommerce archive)', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Product category pages', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Single product pages', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Variable product price ranges', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Sale price displays', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Cart page', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Mini cart widget', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Checkout page', 'woo-bg-dual-currency'); ?></li>
            </ul>
        </div>

        <div>
            <h3><?php _e('Admin & Email Display', 'woo-bg-dual-currency'); ?></h3>
            <ul style="list-style: disc; margin-left: 20px;">
                <li><?php _e('Admin order pages', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Product edit pages', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Order confirmation emails', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Order receipt pages', 'woo-bg-dual-currency'); ?></li>
                <li><?php _e('Invoice displays', 'woo-bg-dual-currency'); ?></li>
            </ul>
        </div>
    </div>

    <hr>

    <h2><?php _e('About the Transition', 'woo-bg-dual-currency'); ?></h2>
    <p><?php _e('Bulgaria is transitioning from BGN (Bulgarian Lev) to EUR (Euro). This plugin helps customers understand both currencies during the transition period by displaying prices in the format:', 'woo-bg-dual-currency'); ?></p>
    <p style="font-size: 18px; font-weight: bold; color: #0073aa;">10.00 лв. / € 5.11</p>

    <p><?php _e('The conversion rate is based on the official exchange rate set by the Bulgarian National Bank: 1 EUR = 1.956 BGN (1 BGN = 0.511292 EUR).', 'woo-bg-dual-currency'); ?></p>
</div>