<?php

/**
 * Fired during plugin activation
 *
 * @link       https://webtospec.com
 * @since      1.0.0
 *
 * @package    Woo_Bg_Dual_Currency
 * @subpackage Woo_Bg_Dual_Currency/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Woo_Bg_Dual_Currency
 * @subpackage Woo_Bg_Dual_Currency/includes
 * @author     Web To Spec <grow@webtospec.com>
 */
class Woo_Bg_Dual_Currency_Activator
{

	/**
	 * Plugin activation handler.
	 *
	 * Sets up default options and checks for WooCommerce.
	 *
	 * @since    1.0.0
	 */
	public static function activate()
	{

		// Set default options
		add_option('woo_bg_dual_currency_conversion_rate', 0.511292);
		add_option('woo_bg_dual_currency_show_in_emails', 1);
		add_option('woo_bg_dual_currency_show_in_admin', 1);

		// Check if WooCommerce is active
		if (! class_exists('WooCommerce')) {
			// Set a notice to inform about WooCommerce requirement
			set_transient('woo_bg_dual_currency_activation_notice', true, 60);
		}
	}
}
